package stocks;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import sun.misc.BASE64Decoder;

/** Serwlet wskazujcy papiery, w ktre warto inwestowa.
 *  Jest on na tyle wyrafinowany, e dostp do niego maj tylko
 *  wybrani uytkownicy (to znaczy ci, ktrzy wnieli
 *  odpowiedni opat).
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */

public class StockTip extends HttpServlet {

  /** Blokuje dostp wszystkim uytkownikom, ktrzy nie znaj
   *  odpowiedniej kombinacji nazwa uytkownika/haso.
   */
  
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    String authorization = request.getHeader("Authorization");
    if (authorization == null) {
      askForPassword(response);
    } else {
      // Nagwki Authorization maj posta "Basic cotamcotam",
      // where cotamcotam to zakodowane w formacie base64 
      // nazwa uytkownika i haso. Nas interesuje cz
      // wystpujca po sowie "Basic ".
      String userInfo = authorization.substring(6).trim();
      BASE64Decoder decoder = new BASE64Decoder();
      String nameAndPassword =
        new String(decoder.decodeBuffer(userInfo));
      // Rozkodowany fragment ma posta "uytkownik:haso".
      int index = nameAndPassword.indexOf(":");
      String user = nameAndPassword.substring(0, index);
      String password = nameAndPassword.substring(index+1);
      // Dodatkowe zabezpieczenie: nazwa uytkownika musi by
      // odwrotnoci hasa.
      if (areEqualReversed(user, password)) {
        showStock(request, response);
      } else {
        askForPassword(response);
      }
    }
  }

  // Wywietlenie strony prezentujcej symbol najbardziej
  // atrakcyjnego papieru wartociowego.

  private void showStock(HttpServletRequest request,
                         HttpServletResponse response)
      throws ServletException, IOException {
        response.setContentType("text/html");
    PrintWriter out = response.getWriter();
    String docType =
      "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 " +
      "Transitional//EN\">\n";
    out.println(docType +
                "<HTML>\n" +
                "<HEAD><TITLE>Najatrakcyjniejszy papier!</TITLE></HEAD>\n" +
                "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                "<H1>Dzisiaj najbardziej atrakcyjnym papierem jest:");
    for(int i=0; i<3; i++) {
      out.print(randomLetter());
    }
    out.println("</H1>\n" +
                "</BODY></HTML>");
  }

  // Jeli w wywoaniu zabrako nagwka Authorization.
  
  private void askForPassword(HttpServletResponse response) {
  	// Wysanie kodu 401
    response.setStatus(HttpServletResponse.SC_UNAUTHORIZED);
    response.setHeader("WWW-Authenticate",
                       "BASIC realm=\"Insider-Trading\"");
  }

  // Zwraca warto true, jeli s1 jest odwrotnoci s2.
  // Puste cigi nie s brane pod uwag.
  
  private boolean areEqualReversed(String s1, String s2) {
    s2 = (new StringBuffer(s2)).reverse().toString();
    return((s1.length() > 0) && s1.equals(s2));
  }
  
  private final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

  // Zwraca losow liczb z przedziau obustronnie 
  // domknitego od 0 do n-1.
  
  private int randomInt(int n) {
    return((int)(Math.random() * n));
  }

  // Losowa litera alfabetu.
  
  private char randomLetter() {
    return(ALPHABET.charAt(randomInt(ALPHABET.length())));
  }
}
